<?php
/*******************************************************************************
 * Stellware - Jugendhilfe Management System                                   *
 *                                                                             *
 * Dieses Programm ist Freie Software. Sie knnen es unter den Bedingungen     *
 * der GNU General Public License (GPL), wie von der Free Software Foundation  *
 * veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess        *
 * Version 2 der Lizenz oder, wenn Sie das wuenschen, nach jeder spaeteren     *
 * Version.                                                                    *
 *                                                                             *
 * Die Veroeffentlichung dieses Programmes erfolgt in der Hoffnung, dass es    *
 * Ihnen von Nutzen sein wird, aber ohne irgendeine Garantie, auch ohne die    *
 * implizite Garantie der Marktreife oder Verwendbarkeit fr irgendeinen       *
 * bestimmten Zweck. Details finden Sie in der GNU General Public License in   *
 * der Datei 'gpl.txt' im Verzeichnis 'doc'.                                   *
 *                                                                             *
 *  http://www.stellware.de                                                    *
 *******************************************************************************
 *
 * $Id: pdf_6.inc.php 3629 2023-05-05 09:59:40Z tfreudenberg $
 *
 */

/* Kopf- und Fuzeilen fr HP-Vorbereitung (mit und ohne Daten)
 *
 *******************/

// FPDF laden
require($_SESSION['basedir'] . "/inc/fpdf/fpdf.php");

class PDF extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
    //Set the array of column widths
    $this->widths=$w;
}

function SetAligns($a)
{
    //Set the array of column alignments
    $this->aligns=$a;
}

function Row($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=4*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,4,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

function CheckPageBreak($h)
{
    //If the height h would cause an overflow, add a new page immediately
    if($this->GetY()+$h>$this->PageBreakTrigger)
        $this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
    //Computes the number of lines a MultiCell of width w will take
    $cw=&$this->CurrentFont['cw'];
    if($w==0)
        $w=$this->w-$this->rMargin-$this->x;
    $wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
    $s=str_replace("\r",'',$txt);
    $nb=strlen($s);
    if($nb>0 and $s[$nb-1]=="\n")
        $nb--;
    $sep=-1;
    $i=0;
    $j=0;
    $l=0;
    $nl=1;
    while($i<$nb)
    {
        $c=$s[$i];
        if($c=="\n")
        {
            $i++;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
            continue;
        }
        if($c==' ')
            $sep=$i;
        $l+=$cw[$c];
        if($l>$wmax)
        {
            if($sep==-1)
            {
                if($i==$j)
                    $i++;
            }
            else
                $i=$sep+1;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
        }
        else
            $i++;
    }
    return $nl;
}

//Page header

function Header()
{
	$adr1 = "";
	$adr2 = "Stellware Demo - an dieser Stelle steht die Adresse";
	global $AppCode;
	global $nurEineSeite;
	global $ersteSeiteNicht;

	if (($this->page == 1 || $nurEineSeite) && empty($ersteSeiteNicht)) {
		$conf_kopf = $_SESSION['basedir'] . '/mandant/' . getConf('traeger') . '/' . getConf('imgKopf');
		$conf_kopf_x = getConf('imgKopf_x');
		$conf_kopf_y = getConf('imgKopf_y');
		$conf_kopf_w = getConf('imgKopf_w');
	    $this->SetFont('stw','',16);
	    if (strlen(getConf('imgKopf')) > 0){
	    	$this->Image($conf_kopf,$conf_kopf_x,$conf_kopf_y,$conf_kopf_w);
	    }
	    $this->SetFillColor(150,150,150);
	    $this->Text(20,20,"");
	    $this->Text(20,27,"");
	    $this->Text(20,34,"");
	    $this->SetFont('stw','',12);
	    $this->Text(152,45,"Stellware Demo");

	    $this->SetFont('Arial','',9);
	    $this->SetXY(133,58);
	    $this->Cell(54,4,'freie Software fr Jugendhilfe',0,0,'R',0);
	    $this->SetXY(133,62);
	    $this->Cell(54,4,'',0,0,'R',0);
	    $this->SetXY(133,66);
	    $this->Cell(54,4,'Telefon',0,0,'R',0);
	    $this->SetXY(133,70);
	    $this->Cell(54,4,'Fax',0,0,'R',0);
	    $this->SetXY(133,74);
	    $this->Cell(54,4,'e-mail',0,0,'R',0);
	    $this->SetXY(133,78);
	    $this->Cell(54,4,'',0,0,'R',0);


	    $this->SetFont('stw','',8);
	    $this->SetXY(20,105);
	    global $adr_typ;
	    $this->Cell(50,5,$adr_typ);
	    $this->Cell(50,5,'AnsprechpartnerIn');
	    $this->Cell(45,5,'Telefon');
	    $this->Cell(20,5,'Datum');

	    $this->SetFont('stw','',8);
	    $this->Text(20,51,$adr1);
	    $this->Text(20,55,$adr2);
	    $this->SetLineWidth(0.1);
	    $this->Line(20,56,90,56);
	} else {
		$conf_logo = $_SESSION['basedir'] . '/mandant/' . getConf('traeger') . '/' . getConf('imgLogo');
		$conf_logo_xh = getConf('imgLogo_xh');
		$conf_logo_y = getConf('imgLogo_y');
		$conf_logo_w = getConf('imgLogo_w');
        $this->SetFont('stw','',12);
        $this->Text(15,13,$adr1);
        if (strlen(getConf('imgLogo')) > 0){
        	$this->Image($conf_logo,$conf_logo_xh,$conf_logo_y,$conf_logo_w);
        }
        $this->SetFillColor(150,150,150);
        $this->Rect(15,15,155,1,'F');
        $this->SetFont('stw','',11);
        global $pnr;
        $this->Text(15,21,$pnr);
        global $unterueberschrift;
		if(isset($unterueberschrift) && !empty($unterueberschrift)) {
			$text = $unterueberschrift;
		} else {
			global $rvar_hp_id;
			$sql = abfrage("select datum from tb_hp where hp_id = '$rvar_hp_id'");
			$dat = date_my2gr($sql[0]);
			$text = "Kindeswohlgefhrdung vom $dat";
		}
		$dat1 = $this->page;
        $this->Text(50,21,$text);
        $this->SetFont('stw','',10);
        $this->Text(150,21,"Seite $dat1 / {nb}");
        $this->Line(5,100,10,100);
        $this->Line(15,23.5,170,23.5);
	}
}

//Page footer
function Footer()
{
	global $AppCode;
    // Brieffu

    $this->SetFont('Arial','',7);
    $this->SetXY(10,270);
    $this->Cell(190,3.5,"Stellware Demo - Stellware ist ein Produkt des Stellwerk e.V.",0,0,'C',0);
    $this->SetXY(10,278);
    $this->Cell(190,3.5,"www.stellwerk-jugendhilfe.de",0,0,'C',0);

    $this->SetLineWidth(0.4);
    $this->SetDrawColor(0,0,0);
    $this->Line(50,283,155,283);

}
}
?>
