<?php
/*******************************************************************************
 * Stellware - Jugendhilfe Management System                                   *
 *                                                                             *
 * Dieses Programm ist Freie Software. Sie knnen es unter den Bedingungen     *
 * der GNU General Public License (GPL), wie von der Free Software Foundation  *
 * veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess        *
 * Version 2 der Lizenz oder, wenn Sie das wuenschen, nach jeder spaeteren     *
 * Version.                                                                    *
 *                                                                             *
 * Die Veroeffentlichung dieses Programmes erfolgt in der Hoffnung, dass es    *
 * Ihnen von Nutzen sein wird, aber ohne irgendeine Garantie, auch ohne die    *
 * implizite Garantie der Marktreife oder Verwendbarkeit fr irgendeinen       *
 * bestimmten Zweck. Details finden Sie in der GNU General Public License in   *
 * der Datei 'gpl.txt' im Verzeichnis 'doc'.                                   *
 *                                                                             *
 *  http://www.stellware.de                                                    *
 *******************************************************************************
 *
 * $Id: pdf_2.inc.php 2699 2017-02-12 16:31:55Z dschniegler $
 *
 */

/* Kopf- und Fuzeile fr Standardlisten, A4 Querformat
 *
 *******************/

// FPDF laden
require($_SESSION['basedir'] . "/inc/fpdf/fpdf.php");

class PDF extends FPDF
{
//Page header

function Header()
{
	$conf_logo = $_SESSION['basedir'] . '/mandant/' . getConf('traeger') . '/' . getConf('imgLogo');
	$conf_logo_xq = 225;
	$conf_logo_y = 5;
	$conf_logo_w = 50;
	global $no_ds;

	// Kopfzeile
	$this->SetFont('stw','',12);
	$this->Text(15,13,getConf('trname'));
	if (strlen(getConf('imgLogo')) > 0){
		$this->Image($conf_logo,$conf_logo_xq,$conf_logo_y,$conf_logo_w);
	}
	$this->SetFillColor(150,150,150);
	$this->Rect(15,15,242,1,'F');
	if ($no_ds == true){
	} else {
		$this->SetFont('stw','',11);
		$this->Text(15,20,'Datenschutz beachten! Aktenvernichter verwenden!');
	}
}

//Page footer
function Footer()
{
	global $footer;
	global $no_nr;
	// Fuzeile
	$this->SetFillColor(150,150,150);
	$this->Rect(15,188,267,1,'F');
	$this->SetFont('arial','',9);
	$footer1 = "Stellware Ausdruck ";
	$footer1 .= date("d.m.Y, H:i");
	$footer1 .= " Uhr";

	$footer2 = $footer;
	$footer2 .= "      Seite ";
	$footer2 .= $this->PageNo() . " / {nb}";

	$this->SetXY(15,190);
	$this->Cell(132,5,$footer1,0,0,'L');
	if ($no_nr == true){
	} else {
		$this->Cell(133,5,$footer2,0,0,'R');
	}
}
}
?>
