<?php
/*******************************************************************************
 * Stellware - Jugendhilfe Management System                                   *
 *                                                                             *
 * Dieses Programm ist Freie Software. Sie knnen es unter den Bedingungen     *
 * der GNU General Public License (GPL), wie von der Free Software Foundation  *
 * veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess        *
 * Version 2 der Lizenz oder, wenn Sie das wuenschen, nach jeder spaeteren     *
 * Version.                                                                    *
 *                                                                             *
 * Die Veroeffentlichung dieses Programmes erfolgt in der Hoffnung, dass es    *
 * Ihnen von Nutzen sein wird, aber ohne irgendeine Garantie, auch ohne die    *
 * implizite Garantie der Marktreife oder Verwendbarkeit fr irgendeinen       *
 * bestimmten Zweck. Details finden Sie in der GNU General Public License in   *
 * der Datei 'gpl.txt' im Verzeichnis 'doc'.                                   *
 *                                                                             *
 *  http://www.stellware.de                                                    *
 *******************************************************************************
 *
 * $Id: pdf_1.inc.php 2699 2017-02-12 16:31:55Z dschniegler $
 *
 */


/* Kopf- und Fuzeile fr Standardlisten, A4 Hochformat
 *
 *******************/

// FPDF laden
require($_SESSION['basedir'] . "/inc/fpdf/fpdf.php");

class PDF extends FPDF
{
//Page header

function Header()
{
	global $no_ds;
	$logo = $_SESSION['basedir'] . '/mandant/swe/stwkopf.jpg';
	$logo_xh = 15;
	$logo_y = 0;
	$logo_w = 172;

	// Kopfzeile
	if (strlen(getConf('imgLogo')) > 0){
		$this->Image($logo,$logo_xh,$logo_y,$logo_w);
	}
	$this->SetFont('Arial','B',12);
	$this->Text(117,11,getConf('trname'));
	if ($no_ds == true){
	} else {
		$this->SetFont('stw','',11);
		$this->Text(75,20,'Datenschutz beachten! Aktenvernichter verwenden!');
	}
}

//Page footer
function Footer()
{
	global $no_footline;
	global $no_foot;
	global $footer;
	global $no_nr;
	// Fuzeile
	if ($no_footline == true){
	} else {
		$this->SetFillColor(150,150,150);
		$this->Rect(15,275,180,1,'F');
	}
	$this->SetFont('Arial','B',9);
	$footer1 = "Stellware Ausdruck ";
	$footer1 .= date("d.m.Y, H:i");
	$footer1 .= " Uhr";

	$footer2 = $footer;
	$footer2 .= "      Seite ";
	$footer2 .= $this->PageNo() . " / {nb}";

	$this->SetXY(15,276);
	if ($no_foot == true){
		$this->Cell(90,5,'',0,0,'L');
	} else {
		$this->Cell(90,5,$footer1,0,0,'L');
	}
	if ($no_nr == true){
	} else {
		$this->Cell(90,5,$footer2,0,0,'R');
	}
}
}
?>
