<?php
/*******************************************************************************
 * Stellware - Jugendhilfe Management System                                   *
 *                                                                             *
 * Dieses Programm ist Freie Software. Sie knnen es unter den Bedingungen     *
 * der GNU General Public License (GPL), wie von der Free Software Foundation  *
 * veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess        *
 * Version 2 der Lizenz oder, wenn Sie das wuenschen, nach jeder spaeteren     *
 * Version.                                                                    *
 *                                                                             *
 * Die Veroeffentlichung dieses Programmes erfolgt in der Hoffnung, dass es    *
 * Ihnen von Nutzen sein wird, aber ohne irgendeine Garantie, auch ohne die    *
 * implizite Garantie der Marktreife oder Verwendbarkeit fr irgendeinen       *
 * bestimmten Zweck. Details finden Sie in der GNU General Public License in   *
 * der Datei 'gpl.txt' im Verzeichnis 'doc'.                                   *
 *                                                                             *
 *  http://www.stellware.de                                                    *
 *******************************************************************************
 *
 * $Id: pdf_7.inc.php 2985 2019-05-12 20:44:58Z dschniegler $
 *
 */

/* Kopf- und Fuzeilen fr HP-Vorbereitung (mit und ohne Daten)
 *
 *******************/

// FPDF laden
require($_SESSION['basedir'] . "/inc/fpdf/fpdf.php");

class PDF extends FPDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
    //Set the array of column widths
    $this->widths=$w;
}

function SetAligns($a)
{
    //Set the array of column alignments
    $this->aligns=$a;
}

function Row($data)
{
    //Calculate the height of the row
    $nb=0;
    for($i=0;$i<count($data);$i++)
        $nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
    $h=4*$nb;
    //Issue a page break first if needed
    $this->CheckPageBreak($h);
    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        $this->MultiCell($w,4,$data[$i],0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

function CheckPageBreak($h)
{
    //If the height h would cause an overflow, add a new page immediately
    if($this->GetY()+$h>$this->PageBreakTrigger)
        $this->AddPage($this->CurOrientation);
}

function NbLines($w,$txt)
{
    //Computes the number of lines a MultiCell of width w will take
    $cw=&$this->CurrentFont['cw'];
    if($w==0)
        $w=$this->w-$this->rMargin-$this->x;
    $wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
    $s=str_replace("\r",'',$txt);
    $nb=strlen($s);
    if($nb>0 and $s[$nb-1]=="\n")
        $nb--;
    $sep=-1;
    $i=0;
    $j=0;
    $l=0;
    $nl=1;
    while($i<$nb)
    {
        $c=$s[$i];
        if($c=="\n")
        {
            $i++;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
            continue;
        }
        if($c==' ')
            $sep=$i;
        $l+=$cw[$c];
        if($l>$wmax)
        {
            if($sep==-1)
            {
                if($i==$j)
                    $i++;
            }
            else
                $i=$sep+1;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
        }
        else
            $i++;
    }
    return $nl;
}

//Page header

function Header()
{
	global $AppCode;
	global $seite;
	$proj_id = $_GET['proj_id'];
	$hp_id = $_GET['hp_id'];

	if ($this->PageNo() > 1) {
		global $headline;
		if(empty($headline)) $headline="Vorbereitung zur Fortschreibung";

		$projekt = new stwProjekt($proj_id);

		switch ($seite){
			case 1:
				$h1 = '7.1 L';
				break;
			case 2:
				$h1 = '7.2 L';
				break;
			case 3:
				$h1 = '7.3 L';
				break;
			case 4:
				$h1 = '7.3 A';
				break;
		}
		if(isset($h1)) $h1 = 'Hilfeplan ' . $h1;
		else if(isset($seite)) $h1 = $seite;
		else $h1 = 'Hilfeplan';

		$this->SetLineWidth(0.1);

		if($this->CurOrientation == 'L') {
			$this->Rect(10,20,277,180);
			$this->SetXY(10,10);

			$this->SetFont('arial','B',11);
			if(strlen($h1)<20) {
				$this->Cell(40,10,$h1,1);
			} else {
				$this->SetFont('arial','B',10);
				$this->Rect(10,10,40,10);
				$this->MultiCell(40,5,$h1,0,'L');
				$this->SetFont('arial','B',11);
				$this->SetXY(50,10);
			}
			$this->Cell(197,10,$headline,1,0,'C');
		} else {
			$this->Rect(20,10,180,277);
			$this->SetY(10);

			$this->SetFont('arial','B',11);
			if(strlen($h1)<20) {
				$this->Cell(40,10,$h1,1);
			} else {
				$this->SetFont('arial','B',10);
				$this->Rect(20,10,40,10);
				$this->MultiCell(40,5,$h1,0,'L');
				$this->SetFont('arial','B',11);
				$this->SetXY(60,10);
			}
			$this->Cell(100,10,$headline,1,0,'C');
		}
		$this->Cell(40,5,"Aktenzeichen:",'LTR',2);
		$this->SetFont('arial','',9);
		$this->Cell(40,5, $projekt->nummer(),'LBR',1);
		if ($this->PageNo() == 1){
			$query = "SELECT t1.name,
						t1.name2,
						CONCAT( t2.anrede, ' ', t2.vorname, ' ', t2.name ) AS sachbearbeiter,
						t2.teldienst, CONCAT(t5.vorname,' ',t5.name) as hauptbetreuer,
						t5.teldienst as telefon,
						t6.kurzname
						FROM tb_kontakte t1
						LEFT JOIN tb_kontakte_ap t2 ON t1.kont_id = t2.kont_id
						LEFT JOIN tb_projekte t3 ON t3.ap_id = t2.ap_id
						LEFT JOIN tbh_pers_proj t4 ON t4.proj_id = t3.proj_id
						LEFT JOIN tb_personal t5 ON t5.pers_id = t4.pers_id
						LEFT JOIN tb_hilfeart t6 ON t6.hilfeart_id = t3.hilfeart_id
						WHERE t3.proj_id =".$_GET['proj_id']."
						AND t4.personaltyp_id =1";
			$res = abfrage1($query);
			$row = mysqli_fetch_array($res);


			$y = $this->GetY();

			$this->SetFont('Arial','B',9);
			$this->Cell(60,4,$row['name'],'LTR',2);
			$this->Cell(60,4,$row['name2'],'LR',2);
			$this->Cell(20,4,'Fachkraft :','L');
			$this->SetFont('Arial','',9);
			$this->Cell(40,4,$row['sachbearbeiter'],'R',2);
			$this->Ln(0);
			$this->SetFont('Arial','B',9);
			$this->Cell(20,4,'Telefon :','LB');
			$this->SetFont('Arial','',9);
			$this->Cell(40,4,$row['teldienst'],'RB',2);

			$this->SetXY(80,$y);

			$this->SetFont('Arial','B',9);
			$this->Cell(35,4,'Hilfeart :','',2);
			$this->Cell(35,4,'Leistungserbringer :','',2);
			$this->Cell(35,4,'Fachkraft :','',2);
			$this->Cell(35,4,'Telefon :','B',2);

			$this->SetXY(115,$y);

			$this->SetFont('Arial','',9);
			$this->Cell(45,4,$row['kurzname'],'R',2);
			$this->Cell(45,4,'Stellwerk Jugendhilfe gGmbH','R',2);
			$this->Cell(45,4,$row['hauptbetreuer'],'R',2);
			$this->Cell(45,4,$row['telefon'],'BR',2);

			$this->SetXY(160,$y);
			$this->Cell(40,16,'','BR',1);
		}
	}
}

//Page footer
function Footer()
{
	global $seite;
	global $newDocAfterPage;
	$proj_id = $_GET['proj_id'];
	$hp_id = $_GET['hp_id'];

	if ($this->PageNo() > 1){

		$date = abfrage("select date_format(datum, '%d.%m.%Y') from tb_hp
						where hp_id = {$_GET['hp_id']};");

		if(isset($seite) && !is_numeric($seite)) $h1 = $seite;
		else $h1 = 'Hilfeplan';
		$fusz  = "Vorbereitung zum $h1 " . projektnummer($proj_id);
		$fusz .= ' am ' . $date[0];

		$this->SetLineWidth(0.1);
		$this->setXY(20,282);
		$this->SetFont('Arial','',7);
		$this->Cell(160,5,$fusz,'T');
		$pgno = $this->PageNo() - 1;
		if(empty($newDocAfterPage)) {
			$this->Cell(20,5,'Seite ' . $pgno . ' von {nb}','T',0,'R');
			$this->setXY(270,200);
			$this->Cell(20,5,'Seite ' . $pgno . ' von {nb}',0,0,'R');
		} else {
			if($pgno > $newDocAfterPage) $pgno -= $newDocAfterPage;
			$this->Cell(20,5,'Seite ' . $pgno . '  ','T',0,'R');
		}
	}
}
} // Ende class PDF
?>
