<?php
/*******************************************************************************
 * Stellware - Jugendhilfe Management System                                   *
 *                                                                             *
 * Dieses Programm ist Freie Software. Sie koennen es unter den Bedingungen    *
 * der GNU General Public License (GPL), wie von der Free Software Foundation  *
 * veroeffentlicht, weitergeben und/oder modifizieren, entweder gemaess        *
 * Version 2 der Lizenz oder, wenn Sie das wuenschen, nach jeder spaeteren     *
 * Version.                                                                    *
 *                                                                             *
 * Die Veroeffentlichung dieses Programmes erfolgt in der Hoffnung, dass es    *
 * Ihnen von Nutzen sein wird, aber ohne irgendeine Garantie, auch ohne die    *
 * implizite Garantie der Marktreife oder Verwendbarkeit fuer irgendeinen      *
 * bestimmten Zweck. Details finden Sie in der GNU General Public License in   *
 * der Datei 'gpl.txt' im Verzeichnis 'doc'.                                   *
 *                                                                             *
 *  http://www.stellware.de                                                    *
 *******************************************************************************
 *
 * $Id: nachw_pr.php 3414 2022-05-13 10:54:09Z tfreudenberg $
 *
 */

 /* Session fuer die Stellwarenutzung starten */
 session_cache_limiter("private");
 session_start();

 /* Sicherheitslevel der notwendig ist */
 if(empty($_GET['proj_id'])) $level = 65;
 $seite = 1;

 /* ein paar Funktionen und automatische Ausgaben werden benoetigt */
 $pfad = substr(__FILE__, 0, strlen(__FILE__) - 24);

 require_once($pfad."inc/auth.inc.php");
 require_once($pfad."inc/level.inc.php");

 $pdf_datei = "mandant/".$_SESSION[$AppCode]["TR"]."/pdf_1.inc.php";
 require_once($pfad.$pdf_datei);

 require_once($pfad."inc/func.inc.php");
extern();
extract($_REQUEST, EXTR_PREFIX_ALL | EXTR_REFS, 'rvar');

setlocale(LC_TIME, 'de_DE@euro');

class PDF_MC_Table extends PDF
{
var $widths;
var $aligns;

function SetWidths($w)
{
    //Set the array of column widths
    $this->widths=$w;
}

function SetAligns($a)
{
    //Set the array of column alignments
    $this->aligns=$a;
}

function Row($data, $multi=true)
{
    //Calculate the height of the row
	if($multi) {
		$nb=0;
		for($i=0;$i<count($data);$i++)
			$nb=max($nb,$this->NbLines($this->widths[$i],$data[$i]));
		$h=4*$nb;
	} else $h=4;
    /* pruefen ob neue Seite notwendig ist */
    $erg = $this->CheckPageBreak($h);

    /*
     * wurde neue Seite angelegt - Header nicht ueberschreiben
     * und deswegen die Y Position neu setzen
     */
    if ($erg == 1) $this->SetY(21.0);

    //Draw the cells of the row
    for($i=0;$i<count($data);$i++)
    {
        $w=$this->widths[$i];
        $a=isset($this->aligns[$i]) ? $this->aligns[$i] : 'L';
        //Save the current position
        $x=$this->GetX();
        $y=$this->GetY();
        //Draw the border
        $this->Rect($x,$y,$w,$h);
        //Print the text
        if($multi) $this->MultiCell($w,4,$data[$i],0,$a);
		else $this->Cell($w,4,$data[$i],0,0,$a);
        //Put the position to the right of the cell
        $this->SetXY($x+$w,$y);
    }
    //Go to the next line
    $this->Ln($h);
}

/*
 * Prueft ob eine neue Seite notwendig ist. Das Argument h gibt an wieviele
 * Pixel hinzugefuegt werden sollen. Ist dieser Wert groesser als die Seite
 * wird eine neue Seite eingefuegt.
 *
 * Rueckgabewerte: 0 - keine neue Seite
 *                 1 - neue Seite
 */
function CheckPageBreak($h)
{
  $neu = 0;

  if($this->GetY()+$h>$this->PageBreakTrigger)
  {
    $this->AddPage($this->CurOrientation);
    $neu = 1;
  }
  return $neu;
}

function NbLines($w,$txt)
{
    //Computes the number of lines a MultiCell of width w will take
    $cw=&$this->CurrentFont['cw'];
    if($w==0)
        $w=$this->w-$this->rMargin-$this->x;
    $wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
    $s=str_replace("\r",'',$txt);
    $nb=strlen($s);
    if($nb>0 and $s[$nb-1]=="\n")
        $nb--;
    $sep=-1;
    $i=0;
    $j=0;
    $l=0;
    $nl=1;
    while($i<$nb)
    {
        $c=$s[$i];
        if($c=="\n")
        {
            $i++;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
            continue;
        }
        if($c==' ')
            $sep=$i;
        $l+=$cw[$c];
        if($l>$wmax)
        {
            if($sep==-1)
            {
                if($i==$j)
                    $i++;
            }
            else
                $i=$sep+1;
            $sep=-1;
            $j=$i;
            $l=0;
            $nl++;
        }
        else
            $i++;
    }
    return $nl;
}

}

$pdf=new PDF_MC_Table('P','mm','A4');
$pdf->Open();
$pdf->AliasNbPages();
$pdf->AddFont('stw','','stw.php');
$pdf->AddFont('arial','','arial.php');
$pdf->AddFont('arialb','','arialb.php');
$pdf->SetAutoPageBreak(false);
$pdf->AliasNbPages();
$pdf->SetLeftMargin(15);

if($_SESSION[$AppCode]['ULV'] < 65 && !empty($_GET['proj_id'])) {
	$prs = abfrage1("select pers_id from tbh_pers_proj where pers_id='".$_SESSION[$AppCode]['UID']."'
					and proj_id='".$_GET['proj_id']."' and personaltyp_id='1'");
	if(mysqli_num_rows($prs)==0) {
		$pdf->AddPage();
		$pdf->SetFont('stw','',30);
		$pdf->Text(20,50,"Fehlende Zugangsberechtigung!");
		$pdf->Output();
		exit;
	}
}

 /* PageBreakTrigger aendern so das Footer nicht mit ueberschrieben wird */
 $pdf->PageBreakTrigger = 274.0;

$zh = 5;
if(isset($rvar_nachw_id))
	$mon = abfrage("select unix_timestamp(datum), datum
					from tb_ab_nachw
					where nachw_id = $rvar_nachw_id;");
elseif(isset($rvar_ab_monat)) {
	$mon[1] = $rvar_ab_monat;
	$mon[0] = date_my2ts($rvar_ab_monat);
} else {
	$mon[0] = mktime(0,0,0, date('n'), 1, date('Y'));
	$mon[1] = date('Y-m-d', $mon[0]);
}
$monat = strftime('%B %Y', $mon[0]);
$monatk = strftime('%m/%Y', $mon[0]);
$abm = $mon[1];
$fmn = date('Y-m-d', mktime(0,0,0, date('n', $mon[0]) + 1, 1, date('Y', $mon[0])));

if(isset($rvar_proj_id))
	$res = abfrage1("select proj_id from tb_projekte where proj_id = '$rvar_proj_id'");
else {
	$sql = "select z.proj_id
			from tb_ab_zk z
			left join tb_projekte p on z.proj_id = p.proj_id
			left join tb_kontakte_ap a on p.ap_id = a.ap_id
			left join tb_kontakte k on a.kont_id = k.kont_id where ";
	if(isset($rvar_nachw_id)) $sql .= "z.nachw_id = $rvar_nachw_id ";
	elseif(isset($rvar_ab_monat)) $sql .= "z.ab = 'j' and z.ab_monat = '$rvar_ab_monat' ";
	else $sql .= "z.ab = 'j' and (z.nachw_id is null or z.nachw_id = 0) ";
	$sql.= "and (pers_id > 0 or code = 'U') and z.code != '$'
			group by p.proj_id
			order by k.kurzname asc, p.projektnr asc;";
	$res = abfrage1($sql);
}
$no_ds = true;
$no_nr = true;
$no_foot = true;

while ($row = mysqli_fetch_row($res)){
	$pageno = 1;
	$pdf->AddPage();

	$pro = new stwProjekt($row[0]);
	$kmg = $pro->kilometergeld($abm);

	/* bei intern: Name Hauptbetreuer oben auf die Seite fuer Zuordnung */
	if ($_GET['ext'] != 1){
		$pdf->SetFont('Arial','BI',12);
		$pdf->Text(100,13,pers_kname($pro->hb()));
	}

	// Fuzeile
	$pdf->SetFont('arial','',9);
	$footer = "Nachweis - " . $pro->nummer() . " - $monatk - Seite $pageno";
	$pdf->SetXY(15,276);
	$pdf->Cell(90,5,$footer,0,0,'L');
	if ($_GET['ext'] == 1 && $pro->sig == 'j'){
		$pdf->Cell(90,10,'','B');
		$pdf->SetXY(105,286);
		$pdf->Cell(90,4,'Unterschrift Leistungsempfnger / Sorgeberechtiger');
	}

	$kont = $pro->kontaktst($abm);
	if($kont) $titel = "Nachweis erbrachter Fachleistungsstunden nach dem SGB VIII";
	else $titel = "Stundennachweis fr ambulante Leistungen der Hilfen zur Erziehung";
	$pdf->SetFont('stw','',12);
	$pdf->Text(15,22,$titel);

	$pdf->SetXY(15,25);
  if($kont) {
	$pdf->Cell(50,$zh,'Leistungserbringer:');
	$pdf->SetFont('arial','',9);
	$erb = abfrage("SELECT traeger_art FROM tb_traeger_art WHERE traeger_art_id = '$pro->traeger_art_id'");
	$pdf->Cell(122,8,$erb[0],1);
	$pdf->SetXY(15,34);
	$pdf->SetFont('stw','',9);
	$pdf->Cell(30,$zh,'Kostentrger:',1);
	$pdf->SetFont('arial','',9);
	$sb = abfrage("select concat(k.name2, ', ', k.name)
					from  tb_kontakte_ap a
					left join tb_kontakte k using (kont_id)
					where a.ap_id = $pro->sb;");
	$pdf->Cell(70,$zh,$sb[0],'RTB');
	$pdf->SetFont('stw','',9);
	$pdf->Cell(42,$zh,'Kostenzusage vom:',1);
	$pdf->SetFont('arial','',9);
	$kzu = $pro->kzu();
	$pdf->Cell(30,$zh,$kzu,'RTB',1);
	$pdf->SetFont('stw','',9);
	$pdf->Cell(30,$zh,'Hilfeempfnger:',1);
	$pdf->SetFont('arial','',9);
	$pdf->Cell(70,$zh,$pro->name(),1);
	$pdf->SetFont('stw','',9);
	$pdf->Cell(42,$zh,'Projekt-Nr.:',1);
	$pdf->SetFont('arial','',9);
	$nr = $pro->nummer();
	$pdf->Cell(30,$zh,$nr,'RTB',1);

	$pdf->SetFont('stw','',9);
	$pdf->Cell(30,$zh,'Hilfeart:',1);
	$pdf->SetFont('arial','',9);
    $ha = abfrage("select concat(hilfeart, ' - ', beschreibung) from tb_hilfeart where hilfeart_id = '$pro->ha';");
	$pdf->Cell(142,$zh,$ha[0],'RTB',1);
	$pdf->SetFont('stw','',9);
	$pdf->Cell(45,$zh,'vereinb. Wochenstunden:',1);
	$pdf->SetFont('arial','',9);
	$wost = fls_form($pro->wost_kontaktstunden($abm));
	if($pro->fallbegleitung($abm)) $wost .= " (+ 1 Fallbegl.)";
	$pdf->Cell(55,$zh,$wost,1);
	$pdf->SetFont('stw','',9);
	$pdf->Cell(42,$zh,'Abrechnungszeitraum:',1);
	$pdf->SetFont('arial','',9);
	$pdf->Cell(30,$zh,$monatk,'RTB',1);
	$pdf->SetFont('stw','',9);
	$pdf->Cell(45,$zh,'bertrag Vormonat:',1);
	$pdf->SetFont('arial','',9);
	$pdf->Cell(55,$zh,fls_form($pro->fls_vormonat($abm)),1);
	$pdf->SetFont('stw','',9);
	$pdf->Cell(42,$zh,'monatl. Arbeitstage:',1);
	$pdf->SetFont('arial','',9);
	$days = arbeitstage($mon[0], mktime(0,0,0, date('n', $mon[0]), date('t', $mon[0]), date('Y', $mon[0])));
	$pdf->Cell(30,$zh,$days,'RTB',1);
	$pdf->SetFont('stw','',9);
	$pdf->Cell(45,$zh,'bisherige FLS gesamt:',1);
	$pdf->SetFont('arial','',9);
	$pdf->Cell(17,$zh,fls_form($pro->fls_geleistet_summe($abm, false)),'TB');
	$pdf->SetFont('stw','',9);
	$pdf->Cell(40,$zh,'( bisherige KLS gesamt:','TB');
	$pdf->SetFont('arial','',9);
	$pdf->Cell(15,$zh,fls_form($pro->fls_geleistet_summe($abm, true)),'TB');
	$pdf->SetFont('stw','',9);
	if($pro->beginn_ts() >= mktime(0,0,0,1,1,2011)) {
		$pdf->Cell(22,$zh,'Soll gesamt:','TB');
		$pdf->SetFont('arial','',9);
		$pdf->Cell(15,$zh,fls_form($pro->fls_soll_summe($abm)),'TB');
		$pdf->SetFont('stw','',9);
		$pdf->Cell(18,$zh,')','TBR');
	} else $pdf->Cell(55,$zh,')','TBR');
  } else {
	$pdf->SetFont('stw','',9);
	$pdf->Cell(30,$zh,'Projekt-Nr.:','LTB');
	$pdf->SetFont('arial','',9);
	$nr = $pro->nummer();
	$pdf->Cell(30,$zh,$nr,'RTB');
	$pdf->SetFont('stw','',9);
	$pdf->Cell(25,$zh,'Monat/Jahr:','LTB');
	$pdf->SetFont('arial','',9);
	$pdf->Cell(35,$zh,$monat,'RTB');
	$pdf->SetFont('stw','',9);
	$pdf->Cell(27,$zh,'R-Nummer:','LTB');
	$pdf->SetFont('arial','',9);
	$pdf->Cell(25,$zh,$pro->reg,'RTB');

	$pdf->Ln($zh);
	$pdf->SetFont('stw','',9);
	$pdf->Cell(30,$zh,'Hilfeempfnger:','LTB');
	$pdf->SetFont('arial','',9);
	$pdf->Cell(40,$zh,$pro->name(),'RTB');
	$pdf->SetFont('stw','',9);
	$pdf->Cell(22,$zh,'zustndig:','LTB');
	$pdf->SetFont('arial','',9);
	$sb = abfrage("select concat(k.name2, ', ', a.anrede, ' ', a.name)
					from  tb_kontakte_ap a
					left join tb_kontakte k using (kont_id)
					where a.ap_id = $pro->sb;");
	$pdf->Cell(80,$zh,$sb[0],'RTB');


	$pdf->Ln($zh);
	$pdf->SetFont('stw','',9);
	$ha = abfrage("select beschreibung from tb_hilfeart
					where hilfeart_id = '{$pro->ha}';");

	/* vorhandene HTML Umlaute wandeln */
	$ha = str_replace("&auml;", "", $ha);
	$ha = str_replace("&uuml;", "", $ha);
	$ha = str_replace("&ouml;", "", $ha);

	$pdf->Cell(25,$zh,'Hilfeart:','LTB');
	$pdf->SetFont('arial','',9);
	$pdf->Cell(147,$zh,$ha[0],'RTB');

	$pdf->Ln($zh);
	$pdf->SetFont('stw','',9);
	$pdf->Cell(44,$zh,'Wochenstunden Hilfeplan:','LTB');
	$pdf->SetFont('arial','',9);
	$hpst = fls_form($pro->wost_datum($abm));
	$pdf->Cell(10,$zh,$hpst,'RTB',0,'R');
	$pdf->SetFont('stw','',9);
	$pdf->Cell(23,$zh,'Sollstunden:','LTB');
	$pdf->SetFont('arial','',9);
	$soll = fls_form($pro->fls_monat($abm));
	$pdf->Cell(12,$zh,$soll,'RTB',0,'R');
	$pdf->SetFont('stw','',9);
	$pdf->Cell(36,$zh,'bertrag Vormonat:','LTB');
	$pdf->SetFont('arial','',9);
	$vm = fls_form($pro->fls_vormonat($abm));
	$pdf->Cell(10,$zh,$vm,'RTB',0,'R');
	$pdf->SetFont('stw','',9);
	$pdf->Cell(27,$zh,'abgerechnet:','LTB');
	$pdf->SetFont('arialb','',9);
	$abger = fls_form($pro->fls_abgerechnet($abm));
	$pdf->Cell(10,$zh,$abger,'RTB',0,'R');
  }
	$sql = "select date_format(t.von, '%d.%m.%Y'),
			date_format(t.von, '%k:%i'),
			date_format(t.bis, '%k:%i'),
			time_format(z.fls, '%k:%i'),
			time_format(sec_to_time(unix_timestamp(t.bis) -
			unix_timestamp(t.von) - time_to_sec(if(time_to_sec(z.fls2) > 0, z.fls2, z.fls)) - time_to_sec(z.vun)), '%k:%i'),
			z.code,
			z.inhalte,
			concat(left(p.vorname, 1), '. ', p.name),
			z.inhalte2,
			z.km_dienst,
			z.km_privat,
			z.spesen_betr,
			z.spesen_eig,
			z.zk_id,
			z.spesen_text,
			r.name,
			concat(p.vorname, ' ', p.name),
			c.code2,
			date_format(t.bis, '%d.%m.%Y'),
			time_format(sec_to_time(time_to_sec(if(time_to_sec(z.fls2) > 0, z.fls2, z.fls)) * 0.7), '%k:%i')
			from tb_ab_zk z
			left join tb_termine t on z.termin_id = t.termin_id
			left join tb_personal p on z.pers_id = p.pers_id
			left join tb_ressourcen r on z.res_id = r.res_id
			left join tb_ab_code2 c on z.code = c.code
			where ";
	if(isset($rvar_nachw_id)) $sql .= "z.nachw_id = $rvar_nachw_id ";
	else $sql .= "z.ab = 'j' and (z.nachw_id is null or z.nachw_id = 0) ";
	$sql .="and (z.pers_id > 0 or z.code = 'U')
			and z.proj_id = $row[0]
			order by unix_timestamp(t.von) asc;";
	$erg = abfrage1($sql);

	if(!$kont) {
		$pdf->SetFont('arial','',6);
		$pdf->Text(63,47,'Fahrzeit');
	}
	$pdf->SetFont('arialb','',9);
	$pdf->Ln($zh * 1.5);

  if($kont) {
	$w = ($_GET['ext'] == 1) ? array(20,20,20,20,30,42,20) : array(17,10,10,10,10,22,10,83);
	$a = ($_GET['ext'] == 1) ? array('L','R','R','R','R','L','C') : array('L','R','R','R','R','L','C','L');
	$w2 = ($_GET['ext'] == 1) ? array(60,20,30,42,20) : array(37,10,10,22,10,83);
	$a2 = ($_GET['ext'] == 1) ? array('L','R','R','L','C') : array('L','R','R','L','C','L');
	$pdf->Cell($w[0],$zh,'Datum',1,0,'C');
	$pdf->Cell($w[1],$zh,'von',1,0,'C');
	$pdf->Cell($w[2],$zh,'bis',1,0,'C');
	if($_GET['ext'] != 1) $pdf->SetFont('arial','',6);
	$pdf->Cell($w[3],$zh,'Fahrzeit',1,0,'C');
	if($_GET['ext'] != 1) $pdf->SetFont('arialb','',9);
	$pdf->Cell($w[4],$zh,'FLS',1,0,'C');
	if($_GET['ext'] == 1) $pdf->Cell($w[5],$zh,'Name der Fachkraft',1,0,'C');
	else $pdf->Cell($w[5],$zh,'Fachkraft',1,0,'C');
	if($_GET['ext'] == 1) $pdf->Cell($w[6],$zh,'Leistungsart',1,0,'C');
	else $pdf->Cell($w[6],$zh,'Code',1,0,'C');
	if($_GET['ext'] != 1) $pdf->Cell($w[7],$zh,'Inhalte',1,0,'C');
 } else {
	$pdf->Cell(17,$zh,'Datum',1,0,'C');
	$pdf->Cell(10,$zh,'von',1,0,'C');
	$pdf->Cell(10,$zh,'bis',1,0,'C');
	$pdf->Cell(10,$zh,'FLS',1,0,'C');
	$pdf->Cell(10,$zh,'E',1,0,'C');
	if ($_GET['ext'] == 1 && $pro->sig == 'j'){
	} else {
		$pdf->Cell(10,$zh,'Code',1,0,'C');
	}
	$pdf->Cell(83,$zh,'Inhalte',1,0,'C');
	$pdf->Cell(22,$zh,'Fachkraft',1,0,'C');
  }
	$pdf->Ln($zh);
	$pdf->SetFont('arial','',7);
	while ($zl = mysqli_fetch_row($erg)){
		if ($zl[4] == '0:00'){
			$fz = '';
		}else {
			$fz = $zl[4];
		}
		if($kont) {
		  if($zl[17] == 'U') {
			$pdf->SetWidths($w2);
			$pdf->SetAligns($a2);
			if($_GET['ext'] == 1)
				$pdf->Row(array("$zl[0] - $zl[18]",'',"$zl[3] (70%: $zl[19])",$pro->hb_name(),($zl[17]=='U'?'':$zl[17])));
			else
				$pdf->Row(array("$zl[0] - $zl[18]",'',$zl[19],$pro->hb_kname(),$zl[17],"berbrckung: 70% von $zl[3] h abgerechnet \nauf Grund $zl[6]"));
		  } else {
			$pdf->SetWidths($w);
			$pdf->SetAligns($a);
			if($_GET['ext'] == 1)
				$pdf->Row(array($zl[0],$zl[1],$zl[2],$fz,$zl[3],$zl[16],$zl[17]));
			else
				$pdf->Row(array($zl[0],$zl[1],$zl[2],$fz,$zl[3],$zl[7],$zl[17],$zl[6]));
		  }
		} else {
		  // Standardzeile fr INTERN und EXTERN
		  if ($_GET['ext'] == 1 && $pro->sig == 'j'){
			$pdf->SetWidths(array(17,10,10,10,10,83,22));
			$pdf->SetAligns(array('L','R','R','R','R','L','L'));
			$pdf->Row(array($zl[0],$zl[1],$zl[2],$zl[3],$fz,$zl[6],$zl[7]));
		  } else {
			$pdf->SetWidths(array(17,10,10,10,10,10,83,22));
			$pdf->SetAligns(array('L','R','R','R','R','C','L','L'));
			$pdf->Row(array($zl[0],$zl[1],$zl[2],$zl[3],$fz,$zl[5],$zl[6],$zl[7]));
		  }
		}


		if ($pdf->GetY() > 250){
			$pdf->AddPage();
			$pageno += 1;

			// Fuzeile
			$pdf->SetFont('arial','',9);
			$footer = "Nachweis - " . $pro->nummer() . " - $monatk - Seite $pageno";
			$pdf->SetXY(15,276);
			$pdf->Cell(90,5,$footer,0,0,'L');
			if ($_GET['ext'] == 1 && $pro->sig == 'j'){
				$pdf->Cell(90,10,'','B');
				$pdf->SetXY(105,286);
				$pdf->Cell(90,4,'Unterschrift Leistungsempfnger / Sorgeberechtiger');
			}

			$pdf->SetY(30);
			$pdf->SetFont('arial','',7);
		}

		// Inhalte B-Akte fr INTERN
		if ($_GET["ext"] != 1 && strlen($zl[8]) > 0){
			if($kont) $pdf->SetWidths(array(22,150));
			else $pdf->SetWidths(array(27,145));
			$pdf->SetAligns(array('R','L'));
			$pdf->Row(array('Inhalte Intern:',$zl[8]));
		}

		if ($pdf->GetY() > 250){
			$pdf->AddPage();
			$pageno += 1;

			// Fuzeile
			$pdf->SetFont('arial','',9);
			$footer = "Nachweis - " . $pro->nummer() . " - $monatk - Seite $pageno";
			$pdf->SetXY(15,276);
			$pdf->Cell(90,5,$footer,0,0,'L');
			if ($_GET['ext'] == 1 && $pro->sig == 'j'){
				$pdf->Cell(90,10,'','B');
				$pdf->SetXY(105,286);
				$pdf->Cell(90,4,'Unterschrift Leistungsempfnger / Sorgeberechtiger');
			}

			$pdf->SetY(30);
			$pdf->SetFont('arial','',7);
		}
		// km-Abrechnung fr INTERN
		if (($_GET["ext"] != 1 || $kmg[0] == 'o') && ($zl[9] > 0 || $zl[10] > 0)){
			if($_GET["ext"] == 1 && $kont) $pdf->SetWidths(array(40,20,20,72,20));
			else $pdf->SetWidths(array(27,20,10,($_GET["ext"] == 1 ? 83 : 93),22));
			$pdf->SetAligns(array('R','R','L','L','L'));
			if ($zl[9] > 0){
				$km = km_form($zl[9]);
				$tx = "Dienst";
			} else {
				$km = km_form($zl[10]);
				$tx = "Privat";
			}
			$tour = abfrage("select km_von, km_via1, km_via2, km_via3, km_via4,
							km_via5, km_nach
							from tb_ab_zk
							where zk_id = $zl[13];");
			$tr = $tour[0];
			for ($i = 1; $i <= 5; $i++) {
				if (strlen($tour[$i]) > 0){
					$tr .= ' > ' . $tour[$i];
				}
			}
			$tr .= $tour[6];
			$auto = (strlen($zl[15])) ? $zl[15] : '';
			$pdf->Row(array('km-Abrechnung:',$km,$tx,$tr,$auto));
		}

		if ($pdf->GetY() > 250){
			$pdf->AddPage();
			$pageno += 1;

			// Fuzeile
			$pdf->SetFont('arial','',9);
			$footer = "Nachweis - " . $pro->nummer() . " - $monatk - Seite $pageno";
			$pdf->SetXY(15,276);
			$pdf->Cell(90,5,$footer,0,0,'L');
			if ($_GET['ext'] == 1 && $pro->sig == 'j'){
				$pdf->Cell(90,10,'','B');
				$pdf->SetXY(105,286);
				$pdf->Cell(90,4,'Unterschrift Leistungsempfnger / Sorgeberechtiger');
			}

			$pdf->SetY(30);
			$pdf->SetFont('arial','',7);
		}

		// Spesen fr INTERN
		if ($_GET["ext"] != 1 && $zl[11] > 0){
			$pdf->SetWidths(array(45,12,10,83,22));
			$pdf->SetAligns(array('R','R','R','L','L'));
			if ($zl[12] > 0){
				$sp2 = $zl[12];
			} else {
				$sp2 = '';
			}
			$pdf->Row(array('Spesen (gesamt / Eigenanteil):',$zl[11],$sp2,$zl[14],''));
		}

		if ($_GET["ext"] != 1){
			$akt_y = $pdf->GetY();
			$pdf->SetY($akt_y + 1);
		}

		if ($pdf->GetY() > 250){
			$pdf->AddPage();
			$pageno += 1;

			// Fuzeile
			$pdf->SetFont('arial','',9);
			$footer = "Nachweis - " . $pro->nummer() . " - $monatk - Seite $pageno";
			$pdf->SetXY(15,276);
			$pdf->Cell(90,5,$footer,0,0,'L');
			if ($_GET['ext'] == 1 && $pro->sig == 'j'){
				$pdf->Cell(90,10,'','B');
				$pdf->SetXY(105,286);
				$pdf->Cell(90,4,'Unterschrift Leistungsempfnger / Sorgeberechtiger');
			}

			$pdf->SetY(30);
			$pdf->SetFont('arial','',7);
		}
	}
	if($kont) {
		$pdf->SetWidths($w2);
		$pdf->SetAligns($a2);
		/* Summe */
		if($_GET['ext'] == 1) $pdf->Row(array('Gesamt:',fls_form($pro->fls_fz_km($abm)),fls_form($pro->fls_gel_netto($abm)),'',''));
		else $pdf->Row(array('Gesamt:',fls_form($pro->fls_fz_km($abm)),fls_form($pro->fls_gel_netto($abm)),'','',''), false);
		/* Legende */
		$pdf->Cell(25,4,"(Leistungsarten: ");
		$pdf->Cell(147,4,"Kontakt - K; Gruppenarbeit - G; Telefonate: T; Fehlkontakt: FK; berbrckung: ; Fallbegleitende Zeit: FZ)",0,1);
	}
	if (flsdoku($abm)){
		if ($_GET['ext'] == 1 && $pro->sig == 'j'){
			$pdf->SetWidths(array(17,10,10,10,10,83,22));
			$pdf->SetAligns(array('L','R','R','R','R','L','L'));
			$pdf->Row(array('','','',fls_form($pro->fls_doku($abm)),'',"Falldokumentation kumuliert",''));
		} else {
			$pdf->SetWidths(array(17,10,10,10,10,10,83,22));
			$pdf->SetAligns(array('L','R','R','R','R','C','L','L'));
			$pdf->Row(array('','','',fls_form($pro->fls_doku($abm)),'',"B","Falldokumentation kumuliert",''));
		}
	}

	//Summenblock

	$sum_y = $kont ? 213 : 220;
	$sum_y2 = $sum_y;

	// Summenblock km und Spesen -> NUR INTERN!
	if ($_GET["ext"] != 1 || $kmg[0] == 'o') {
		$sql = "select sum(z.km_dienst), sum(z.km_privat),
				concat(left(p.vorname, 1), '. ', p.name)
				from tb_ab_zk z
				left join tb_personal p using(pers_id)
				where ";
		if(isset($rvar_nachw_id)) $sql .= "z.nachw_id = $rvar_nachw_id ";
		else $sql .= "z.ab = 'j' and (z.nachw_id is null or z.nachw_id = 0) ";
		$sql.= "and z.proj_id = $row[0]
				and (z.km_dienst > 0 or z.km_privat > 0)
				and pers_id > 0
				group by z.pers_id
				order by p.name asc, p.vorname asc;";
		$km = abfrage1($sql);

		$sql = "select sum(z.spesen_betr), sum(z.spesen_eig),
				concat(left(p.vorname, 1), '. ', p.name)
				from tb_ab_zk z
				left join tb_personal p using(pers_id)
				where ";
		if(isset($rvar_nachw_id)) $sql .= "z.nachw_id = $rvar_nachw_id ";
		else $sql .= "z.ab = 'j' and (z.nachw_id is null or z.nachw_id = 0) ";
		$sql.= "and z.proj_id = $row[0]
				and z.spesen_betr > 0
				and pers_id > 0
				group by z.pers_id
				order by p.name asc, p.vorname asc;";
		$sp = abfrage1($sql);

		$ckm = mysqli_num_rows($km);
		$csp = mysqli_num_rows($sp);

		if ($ckm > 0 || $csp > 0){
			if ($ckm >= $csp){
				$czl = ($ckm + 1) * $zh;
			} else {
				$czl = ($csp + 1) * $zh;
			}
			$sum_y2 = $sum_y - $czl;
		}
	}

	// Seitenumbruch, falls nicht mehr genug Platz
	if ($pdf->GetY() > $sum_y2){
		$pdf->AddPage();

		$pageno += 1;
		// Fuzeile
		$pdf->SetFont('arial','',9);
		$footer = "Nachweis - " . $pro->nummer() . " - $monatk - Seite $pageno";
		$pdf->SetXY(15,276);
		$pdf->Cell(90,5,$footer,0,0,'L');
		if ($_GET['ext'] == 1 && $pro->sig == 'j'){
			$pdf->Cell(90,10,'','B');
			$pdf->SetXY(105,286);
			$pdf->Cell(90,4,'Unterschrift Leistungsempfnger / Sorgeberechtiger');
		}

		$pdf->SetY(30);
		$pdf->SetFont('arial','',7);
	}

	// Block km- und Spesensummen - nur INTERN
	if ($_GET["ext"] != 1 && ($ckm > 0 || $csp > 0)){
		if ($ckm > 0){
			$pdf->SetXY(15, $sum_y2);
			$pdf->SetFont('arialb','',9);
			$pdf->Cell(85,$zh,'Summen km-Abrechnung',1);
			$pdf->Ln();
		}
		$pdf->SetFont('arial','',9);
		while ($zeile = mysqli_fetch_row($km)){
			$pdf->Cell(35,$zh,$zeile[2],1);
			if ($zeile[0] > 0){
				$kmd = km_form($zeile[0]) . " Dienst";
			} else {
				$kmd = '';
			}
			if ($zeile[1] > 0){
				$kmp = km_form($zeile[1]) . " Privat";
			} else {
				$kmp = '';
			}
			$pdf->Cell(25,$zh,$kmd,1,0,'R');
			$pdf->Cell(25,$zh,$kmp,1,0,'R');
			$pdf->Ln();
		}

		if ($csp > 0){
			$pdf->SetXY(100, $sum_y2);
			$pdf->SetFont('arialb','',9);
			$pdf->Cell(85,$zh,'Summen Spesen',1);
			$pdf->Ln();
			$pdf->SetX(100);
		}
		$pdf->SetFont('arial','',9);
		while ($zeile = mysqli_fetch_row($sp)){
			$pdf->Cell(35,$zh,$zeile[2],1);
			if ($zeile[0] > 0){
				$kmd = $zeile[0] . " EUR";
			} else {
				$kmd = '';
			}
			if ($zeile[1] > 0){
				$kmp = "- $zeile[1] EUR Eig.";
			} else {
				$kmp = '';
			}
			$pdf->Cell(20,$zh,$kmd,1,0,'R');
			$pdf->Cell(30,$zh,$kmp,1,0,'R');
			$pdf->Ln();
			$pdf->SetX(100);
		}
	}
	// Summen km, falls in Extern
	if($_GET["ext"]==1 && $kmg[0]=='o' && $ckm > 0) {
		$kilometer = 0;
		while ($zeile = mysqli_fetch_row($km)){
			$kilometer += $zeile[0] + $zeile[1];
		}
		$pdf->SetXY(120, $sum_y);
		$pdf->SetFont('arialb','',9);
		$pdf->Cell(50,$zh,'Summe km-Abrechnung');
		$pdf->SetFont('arial','',9);
		$pdf->Cell(20,$zh,km_form($kilometer),0,0,'R');
	}
	if($_GET["ext"]==1 && $kmg[0]=='j') {
		$sql = "select sum(z.km_abw_ja)
				from tb_ab_zk z
				where ";
		if(isset($rvar_nachw_id)) $sql .= "z.nachw_id = $rvar_nachw_id ";
		else $sql .= "z.ab = 'j' and (z.nachw_id is null or z.nachw_id = 0) ";
		$sql.= "and z.proj_id = $row[0]
				and (z.km_abw_ja > 0)
				and z.pers_id > 0";
		$kmabw = abfrage($sql);
		if($kmabw[0] > 0) {
			$pdf->SetXY(120, $sum_y);
			$pdf->SetFont('arialb','',9);
			$pdf->Cell(50,$zh,'Summe km-Abrechnung');
			$pdf->SetFont('arial','',9);
			$pdf->Cell(20,$zh,km_form($kmabw[0]),0,0,'R');
		}
	}

	// Summenblock INTERN + EXTERN!
	$pdf->SetXY(15,$sum_y);
	$pdf->SetLineWidth(0.35);

	$pdf->SetFont('arialb','',9);
	$sum = $kont ? "Kontaktstunden (KLS)" : "A - D";
	$pdf->Cell(42,$zh,"Summe $sum",'T');
	$fls_gel = fls_form($pro->fls_gel_netto($abm) + $pro->fls_doku($abm));

	$pdf->Cell(20,$zh,$fls_gel,'T',0,'R');
	$pdf->Cell(113,$zh,'','T');

	$pdf->SetLineWidth(0.2);
	$pdf->Ln($zh);
	if(!$kont) {
	  if ($pro->km == 'j' && $pro->kmd <= $abm){
		$pdf->Cell(42,$zh,'Summe E (nicht berechnet)','B');
		$pdf->SetFont('arialb','',9);
		$pdf->SetFont('arialb','',9);
		$pdf->Cell(30,$zh,fls_form($pro->fls_fz_km($abm)),'B',0,'R');
	  } else {
		$pdf->Cell(42,$zh,'Summe E','B');
		$pdf->Cell(20,$zh,fls_form($pro->fls_fz($abm)),'B',0,'R');
	  }

	  if ($pro->fls_fz_brutto($abm) > $pro->fls_fz($abm)){
		$flsFzProz = getFlsFzProz($abm,$pro->id);
		$pdf->SetFont('arial','',9);
		$brt = fls_form($pro->fls_fz_brutto($abm));
		$pdf->Cell(65,$zh,"(gekrzt auf $flsFzProz% von Summe A-D von $brt)",'B');
		$pdf->SetFont('arialb','',9);
	  }

	  $pdf->Ln($zh);
	  $pdf->SetFont('arialb','',9);
	  $pdf->Cell(42,$zh,'Summe FLS');
	  $pdf->Cell(20,$zh,fls_form($pro->fls_gesamt($abm)),0,0,'R');
	  $pdf->Ln($zh);
	}
	$pdf->SetFont('arialb','',9);

	if ($pro->pool()){
		$pdf->Cell(42,$zh,'Stunden-Pool insgesamt','T');
		$pdf->Cell(20,$zh,fls_form($pro->pool_st($abm)),'T',0,'R');
	} else {
		$pdf->Cell(42,$zh,'Summe lt. Hilfeplan','B');
		$pdf->Cell(20,$zh,fls_form($pro->fls_monat($abm)),'B',0,'R');
	}

	$pdf->Ln($zh);
	$pdf->SetFont('arialb','',9);

	if ($pro->pool()){
		$pdf->Cell(42,$zh,'Pool-Stand Vormonat');
		$ts = date_isodate_stamp($abm);
		$ts = mktime(0,0,0,date('n', $ts) - 1, 1, date('Y', $ts));
		$ts = date('Y-m-d', $ts);
		$pdf->Cell(20,$zh,fls_form($pro->pool_stand($ts)),0,0,'R');
	} else {
		$pdf->Cell(42,$zh,'bertrag Vormonat');
		$pdf->Cell(20,$zh,fls_form($pro->fls_vormonat($abm)),0,0,'R');
	}

	$pdf->SetFont('arial','',9);
	$pdf->Cell(50,$zh,'');

	$pdf->Ln($zh);
	$pdf->SetFont('arialb','',9);

	if ($pro->pool()){
		$pdf->Cell(42,$zh,'Pool-Stand Folgemonat');
		$pdf->Cell(20,$zh,fls_form($pro->pool_stand($abm)),0,0,'R');
	} else {
		if($kont) $pdf->SetLineWidth(0.4);
		$pdf->Cell(42,$zh,'bertrag Folgemonat','B');
		$pdf->Cell(20,$zh,fls_form($pro->fls_vormonat($fmn)),'B',0,'R');
	}

	$txt = '';
	if(!$pro->pool()) {
		$kapp_mod = $pro->fls_kappung($abm);
		$dat_fm = $pro->fls_folgemonat($abm);
		if(($kapp_mod['kapp_pos'] == 1 && $dat_fm > 0 && $dat_fm > $kapp_mod['kapp_pos_wert']) ||
		   ($kapp_mod['kapp_neg'] == 1 && $dat_fm < 0 && $dat_fm < $kapp_mod['kapp_neg_wert']))
				$txt = "(gekrzt von ".fls_form($dat_fm).")";
	}
	if (empty($txt)) $pdf->Cell(45,$zh,'');
	else {
		$pdf->SetFont('arial','',9);
		$pdf->Cell(35,$zh,$txt,'B');
		$pdf->SetFont('arialb','',9);
		$pdf->Cell(10,$zh,'');
	}
	$pdf->SetLineWidth(0.2);

	if($kont) {
	  $fahrzeit = $pro->fls_fz($abm);
	  $pdf->SetFont('arialb','',9);

	  $pdf->Ln($zh);
	  $pdf->Cell(42,$zh,'Summe KLS abgerechnet');
	  $pdf->Cell(20,$zh,fls_form($pro->fls_abgerechnet($abm) - $fahrzeit),0,0,'R');

	  $pdf->Ln($zh);
	  $pdf->Cell(42,$zh,'Summe Fahrzeit','B');
	  $pdf->Cell(20,$zh,fls_form($fahrzeit),'B',0,'R');

	  $pdf->Ln($zh);
	  $pdf->Cell(42,$zh,'Summe FLS abgerechnet','B');
	  $pdf->Cell(20,$zh,fls_form($pro->fls_abgerechnet($abm)),'B',0,'R');
	  $pdf->Cell(45,$zh,'');
	}

	$pdf->SetFont('arial','',8);
	$datum = 'Rechtsverb. Unterschrift - '. getConf('trort') . ', ' . date('d.m.Y');
	$pdf->Cell(63,$zh,$datum,'T',0,'C');

	if($kont) {
	  $pdf->Ln($zh);
	  $pdf->Cell(62,0.5,'','B');
	}

	$kon = abfrage("select kontrolle, pers_id, date_format(datetime, '%d.%m.%Y %H:%i'),
					pers_id_hb, date_format(datetime_hb, '%d.%m.%Y %H:%i'),
					pers_id_rech, date_format(datetime_rech, '%d.%m.%Y %H:%i')
					from tb_ab_proj_kont
					where proj_id = $pro->id
					and ab_monat = '$abm';");

	$pdf->SetFont('stw','',7);
	if(($kon[0] & 1) > 0) {
		$pdf->SetXY(122,238);
		$pdf->Cell(60,3.5,"elektronische Signatur:",0,2);
		$pdf->Cell(60,3.5,pers_name($kon[1]) . ' ' . $kon[2]);
	}
	if($_GET["ext"] != 1 && (($kon[0] & 2) > 0)) {
		$pdf->SetXY(122,253);
		$pdf->Cell(60,3.5,"elektronische Signatur:",0,2);
		$pdf->Cell(60,3.5,pers_name($kon[3]) . ' ' . $kon[4]);
	}
	if($_GET["ext"] != 1 && (($kon[0] & 4) > 0)) {
		$pdf->SetXY(121,220);
		$pdf->Cell(70,3.5,"geprft: sachlich richtig " . pers_name($kon[3]) . ' ' . ($kon[4] == '00.00.0000 00:00' ? '' : $kon[4]),0,0,'R');
	}
	// Block Jugendamt
	$pdf->SetFont('arial','',9);
	if ($_GET["ext"] == 1){
		$pdf->SetLineWidth(0.35);
		$pdf->Line(100,250,100,275);
		$pdf->SetY(250);
		$pdf->Cell(170,$zh,'(vom Jugendamt auszufllen)','T');

		$pdf->Ln($zh);
		$pdf->SetLineWidth(0.2);
		$pdf->SetFont('arialb','',9);
		$pdf->Cell(40,$zh,'sachlich richtig:');
		$pdf->Cell(10,$zh,'');
		$pdf->SetFont('arial','',9);
		$pdf->Cell(30,$zh,'Weitergabe an WiHi');

		$pdf->Cell(10,$zh,'');
		$pdf->SetFont('arialb','',9);
		$pdf->Cell(40,$zh,'rechnerisch richtig:');
		$pdf->Cell(10,$zh,'');
		$pdf->SetFont('arial','',9);
		$pdf->Cell(30,$zh,'Buchung in RECOS');

		$pdf->Ln($zh * 3);
		$pdf->Cell(40,$zh,'Datum / Unterschrift / ASD','T');
		$pdf->Cell(10,$zh,'');
		$pdf->Cell(30,$zh,'','T');

		$pdf->Cell(10,$zh,'');
		$pdf->Cell(40,$zh,'Datum / Unterschrift / WiHi','T');
		$pdf->Cell(10,$zh,'');
		$pdf->Cell(30,$zh,'','T');

		$pdf->SetLineWidth(0.2);
	}

	if ($_GET["ext"] != 1){
		$pdf->SetXY(122,260);
		$pdf->SetFont('arial','',8);
		$pdf->Cell(63,$zh,'Unterschrift Betreuer','T',0,'C');
	}
}

$pdf->Output();
exit;
?>
